function [ z ] = func_error_ellipse( Rz )
% [ z ] = func_error_ellipse( Rz )
% 
% Inputs: 
%   Rz - covariance matrix in R^2
%
% Outputs:
%   z  - confidence ellipse points
%
% Description: Compute error ellipse points in R^2
% Reference: 'Bayesian Estimation with Distance Bounds'
%             to appear in IEEE Signal Processing Letters
% Edit: Dave Zachariah and Isaac Skog, 2012-06-10
% Contact: {dave.zachariah, isaac.skog}@ee.kth.se
% Copyright: (c) 2012 KTH, ISC License (open source)
%

%% Compute ellipse points
n=100; % Number of points around ellipse
p=(0:pi/n:2*pi)'; % angles around a circle

[V, D_lambda] = eig(Rz); % Compute eigenvalues and -vectors
z = [cos(p) sin(p)] * sqrt( abs(D_lambda) ) * real( V' ); % Transformation (ensure real valued eigenvalues)