function Comp = filling(InComp)
%
%   function linearly interpolates and extrapolates the missing points in
%   the matrix InComp. The missing points are identified with NANs. 
%   'filling.m' is inspired in a inpainting function 'inpaint_nans.m' by John D'Errico. 
%

%
%    Efrain Zenteno
%    University of Gvle, Sweden
%    The Royal Institute of Technology KTH, Sweden
%    2014/09/04
%

Comp = InComp;
[filas,colums] = size(InComp);
InComp = InComp(:);
nm = filas*colums;
k = isnan(InComp);

empty_lis = find(k);
known_list = find(~k);
[nr,nc] = ind2sub([filas,colums],empty_lis);
empty_lis=[empty_lis,nr,nc];


[i,j] = ndgrid(2:(filas-1),1:colums);
idx = i(:)+(j(:)-1)*filas;
np = (filas-2)*colums;
SpStr = sparse(repmat(idx,1,3),[idx-1,idx,idx+1],repmat([1 -2 1],np,1),filas*colums,filas*colums);
    
[i,j] = ndgrid(1:filas,2:(colums-1));
idx = i(:)+(j(:)-1)*filas;
np = filas*(colums-2);
SpStr = SpStr + sparse(repmat(idx,1,3),[idx-filas,idx,idx+filas],repmat([1 -2 1],np,1),nm,nm);
  
Idvec = -SpStr(:,known_list)*InComp(known_list);
k = find(any(SpStr(:,empty_lis),2));
  
Comp(empty_lis(:,1)) = SpStr(k,empty_lis(:,1))\Idvec(k);
Comp = reshape(Comp,filas,colums);





