function ym = run_density(u,Pn,x)
% 
%   function run_density(u,Pn,x)
%      propagate complex-valued data u through the density model Pn
%      estimated at a grid x.
%
%
%      Inputs:
%         u: (vector) complex-valued input data
%         Pn: (matrix) density model (transfer function)
%              Pn is linearly extrapolated for values outsied estimation
%         x: (vector) grid of estimation points for real and imag. parts
%
%
%      Outputs:
%         ym: (vector)  output of the model.
%
%
%


%
%    Efrain Zenteno  /   Zain Ahmed Khan
%    University of Gvle, Sweden
%    The Royal Institute of Technology KTH, Sweden
%    2014/09/04
%

% linearly interpolating / extrapolating the un-estimated points in the
% density model.  
Pn = filling(Pn);
% note that for few estimation samples the density model will interpolate
% and extrapolate more and more points of the function 
% (we need persistant excitation to have realible estimation)


[xx yy] = meshgrid(x);
p_dist = angle(Pn)-angle(xx+1i*yy);

% avoid phase discontinuities
p_dist(abs(p_dist)>pi) = p_dist(abs(p_dist)>pi) - sign(p_dist(abs(p_dist)>pi))*2*pi;

% model propagation
y_mod_abs = interp2(x,x,abs(Pn),real(u),imag(u));    % mag
y_mod_pha = interp2(x,x,p_dist,real(u),imag(u));  % phase dist

ym = y_mod_abs.*exp(1i*(angle(u)+y_mod_pha));
