% For zero-one sparse data creation where the data is sparse

% Written by: Saikat Chatterjee of KTH
% Email: saikatchatt@gmail.com
% Created: 21'st July 2010


function [X U] = SparseDataCreate_ZeroOne(NoOfData,N,K)

% Input
% NoOfData -> Number of vectors to be generated
% N -> Dimension of the approximately sparse vector X
% K -> Dimension of U. So, X is nearly K-sparse

% Output
% The approximately sparse data 'X'
% The strictly sparse data 'U'


% Data X=U+V
X=zeros(NoOfData,N);
U=zeros(NoOfData,N);


for i=1:NoOfData
    
    x=zeros(1,N);
    q = randperm(N);
    
    x(q(1:K)) = 1;
    U(i,:)=x;
    
    x(q(K+1:N)) = 0;
    X(i,:)=x;
end