function [ x_hat, I, r ] = iter_l1_omp_sipp( y, A, Kmax, epsilon)

[frame_length, N] = size(A);

yr = y;
Tini = []; T_max = [];

loop = 0;
while 1
    loop = loop + 1 ;
    T_old = T_max;
    yr_old = yr;
    
    Tini_c = setdiff([1:1:N],Tini);
    var_size = length(Tini_c);A_eff = A(:,Tini_c);
    cvx_begin quiet
        variable x_partial(var_size);
        minimize( norm(x_partial,1));
        subject to
        norm(yr_old - A_eff*x_partial,2) <= epsilon;
    cvx_end
    xp_BPDN = zeros(1,N); xp_BPDN(Tini_c)= x_partial;
    I_l1_SIPP = max_indices(xp_BPDN, Kmax);
    
    [xp_omp_SIPP, I_omp_SIPP, y_r_omp_SIPP]=ipp_omp(y,A,Kmax,Tini);
    [xp_sp_IPP, I_sp_IPP, y_r_sp_IPP]=ipp_sp(y,A,Kmax,Tini);
    
%     Tini = intersect(I_SIPP, I_sp_IPP);
    T_union_temp = union(I_l1_SIPP, I_sp_IPP);
    T_union = union(T_union_temp, I_omp_SIPP);
    
    x_temp = zeros(1,N);
    x_temp_dummy = A(:,T_union)\y;
    x_temp(T_union) = x_temp_dummy;
    
    T_max = max_indices(x_temp, Kmax);Tini =T_max;
    
    yr = resid(y, A(:,T_max));
    if(norm(yr) >= norm(yr_old))
       T_max = T_old;
       yr = yr_old;
       break;
    end
end
xp = A(:,T_max)\y;
x_hat = zeros(N,1);
x_hat(T_max) = xp;
I = T_max;
r = yr;