%% %%%%%%%%%%%%%%%%%%%%%%%
figure

SMNR=20;str_type='Gaussian';N=500;
str1=cat(2,'SRNR_for_',str_type);
str1=cat(2,str1,'_Signal_at_SMNR_');
str2=int2str(SMNR);
str1=cat(2,str1,str2);
str3='.txt';
str1=cat(2,str1,str3);
SRNR_all=load(str1);
alpha11=SRNR_all(1,:)/N;
subplot(2,2,1);
plot(alpha11,SRNR_all(2,:),'-o',alpha11,SRNR_all(3,:),'-*',alpha11,SRNR_all(6,:),'-s',alpha11,SRNR_all(4,:),'-^',alpha11,SRNR_all(5,:),'-v');grid on
xlabel('Fraction of measurements'); ylabel('SRNR (in dB)');
legend('OMP','SP','BPDN','UACS-1','UACS-2');
title('Gaussian Source, SMNR = 20dB');

SMNR=20;str_type='Binary';N=500;
str1=cat(2,'SRNR_for_',str_type);
str1=cat(2,str1,'_Signal_at_SMNR_');
str2=int2str(SMNR);
str1=cat(2,str1,str2);
str3='.txt';
str1=cat(2,str1,str3);
SRNR_all=load(str1);
alpha11=SRNR_all(1,8:end)/N;
subplot(2,2,2);
plot(alpha11,SRNR_all(2,8:end),'-o',alpha11,SRNR_all(3,8:end),'-*',alpha11,SRNR_all(6,8:end),'-s',alpha11,SRNR_all(4,8:end),'-^',alpha11,SRNR_all(5,8:end),'-v');grid on
xlabel('Fraction of measurements'); ylabel('SRNR (in dB)');
legend('OMP','SP','BPDN','UACS-1','UACS-2');
title('Binary Source, SMNR = 20dB');

SMNR=200;str_type='Gaussian';N=500;
str1=cat(2,'SRNR_for_',str_type);
str1=cat(2,str1,'_Signal_at_SMNR_');
str2=int2str(SMNR);
str1=cat(2,str1,str2);
str3='.txt';
str1=cat(2,str1,str3);
SRNR_all=load(str1);
alpha11=SRNR_all(1,:)/N;
subplot(2,2,3);
plot(alpha11,SRNR_all(2,:),'-o',alpha11,SRNR_all(3,:),'-*',alpha11,SRNR_all(6,:),'-s',alpha11,SRNR_all(4,:),'-^',alpha11,SRNR_all(5,:),'-v');grid on
xlabel('Fraction of measurements'); ylabel('SRNR (in dB)');
legend('OMP','SP','BPDN','UACS-1','UACS-2');
title('Gaussian Source, Clean Measurement');

SMNR=200;str_type='Binary';N=500;
str1=cat(2,'SRNR_for_',str_type);
str1=cat(2,str1,'_Signal_at_SMNR_');
str2=int2str(SMNR);
str1=cat(2,str1,str2);
str3='.txt';
str1=cat(2,str1,str3);
SRNR_all=load(str1);
alpha11=SRNR_all(1,8:end)/N;
subplot(2,2,4);
plot(alpha11,SRNR_all(2,8:end),'-o',alpha11,SRNR_all(3,8:end),'-*',alpha11,SRNR_all(6,8:end),'-s',alpha11,SRNR_all(4,8:end),'-^',alpha11,SRNR_all(5,8:end),'-v');grid on
xlabel('Fraction of measurements'); ylabel('SRNR (in dB)');
legend('OMP','SP','BPDN','UACS-1','UACS-2');
title('Binary Source, Clean Measurement');

%% %%%%%%%%%%%%%%%%%%%%%%%%%
figure

SMNR=20;str_type='Gaussian';
str1=cat(2,'ASCE_for_',str_type);
str1=cat(2,str1,'_Signal_at_SMNR_');
str2=int2str(SMNR);
str1=cat(2,str1,str2);
str3='.txt';
str1=cat(2,str1,str3);
ASCE_all=load(str1);
alpha11=ASCE_all(1,:)/N;
subplot(2,2,1);
semilogy(alpha11,ASCE_all(2,:),'-o',alpha11,ASCE_all(3,:),'-*',alpha11,ASCE_all(6,:),'-s',alpha11,ASCE_all(4,:),'-^',alpha11,ASCE_all(5,:),'-v');grid on
xlabel('Fraction of measurements'); ylabel('ASCE');
legend('OMP','SP','BPDN','UACS-1','UACS-2');
title('Gaussian Source, SMNR = 20dB');

SMNR=20;str_type='Binary';
str1=cat(2,'ASCE_for_',str_type);
str1=cat(2,str1,'_Signal_at_SMNR_');
str2=int2str(SMNR);
str1=cat(2,str1,str2);
str3='.txt';
str1=cat(2,str1,str3);
ASCE_all=load(str1);
alpha11=ASCE_all(1,8:end)/N;
subplot(2,2,2);
semilogy(alpha11,ASCE_all(2,8:end),'-o',alpha11,ASCE_all(3,8:end),'-*',alpha11,ASCE_all(6,8:end),'-s',alpha11,ASCE_all(4,8:end),'-^',alpha11,ASCE_all(5,8:end),'-v');grid on
xlabel('Fraction of measurements'); ylabel('ASCE');
legend('OMP','SP','BPDN','UACS-1','UACS-2');
title('Binary Source, SMNR = 20dB');

SMNR=200;str_type='Gaussian';
str1=cat(2,'ASCE_for_',str_type);
str1=cat(2,str1,'_Signal_at_SMNR_');
str2=int2str(SMNR);
str1=cat(2,str1,str2);
str3='.txt';
str1=cat(2,str1,str3);
ASCE_all=load(str1);
alpha11=ASCE_all(1,:)/N;
subplot(2,2,3);
semilogy(alpha11,ASCE_all(2,:),'-o',alpha11,ASCE_all(3,:),'-*',alpha11,ASCE_all(6,:),'-s',alpha11,ASCE_all(4,:),'-^',alpha11,ASCE_all(5,:),'-v');grid on
xlabel('Fraction of measurements'); ylabel('ASCE');
legend('OMP','SP','BPDN','UACS-1','UACS-2');
title('Gaussian Source, Clean Measurement');

SMNR=200;str_type='Binary';
str1=cat(2,'ASCE_for_',str_type);
str1=cat(2,str1,'_Signal_at_SMNR_');
str2=int2str(SMNR);
str1=cat(2,str1,str2);
str3='.txt';
str1=cat(2,str1,str3);
ASCE_all=load(str1);
alpha11=ASCE_all(1,8:end)/N;
subplot(2,2,4);
semilogy(alpha11,ASCE_all(2,8:end),'-o',alpha11,ASCE_all(3,8:end),'-*',alpha11,ASCE_all(6,8:end),'-s',alpha11,ASCE_all(4,8:end),'-^',alpha11,ASCE_all(5,8:end),'-v');grid on
xlabel('Fraction of measurements'); ylabel('ASCE');
legend('OMP','SP','BPDN','UACS-1','UACS-2');
title('Binary Source, Clean Measurement');