function generate_ref_kmer_vector_SEK(REF_seq, k)

    % This script is used to read in all the reference sequences. Then
    % obtain the 450bp fragments along these reference sequences. The step
    % is set as 1bp. 
    
    % k is set 3, 4, 5 or 6 as the kmer.
    
    %% code.
    
%     reference_seqs = fastaread(REF_seq);
    
    reference_seqs = REF_seq;
    
    n = size(reference_seqs,1);
    
    all_species_kmer_vector = cell(n,1);
    
    for i = 1:n
        
%         disp(reference_seqs(i,1).Header);
        
        L = 450; % the length of fragment is set as 450bp.
        N = length(reference_seqs(i,1).Sequence)-L+1; % the number of fragments could be generated by reference sequecnes.
        
        species_kmer_vector = zeros(N,4^k);
        seq = reference_seqs(i,1).Sequence;
        
        for j = 1:N
            species_kmer_vector(j,:) = kmer_statistics(seq(j:(j+L-1)),k)';
            %species_kmer_vector(j,:) = statistics_kmer_mean_pos(seq(j:(j+L-1)),k)';
        end
        
        all_species_kmer_vector{i,1} = species_kmer_vector;
    end
    
%     filename = strcat('kmer_',num2str(k),'_vector_allref.mat');
    filename = strcat('kmer_vector_allref_SEK.mat');
    save(filename,'all_species_kmer_vector');
end