function [ C ] = generate_connection_matrix_rand( nodes, connections )
% From a circular connection matrix, generate random connections as to make
% sure the average number of connections correspond to connections
%   Detailed explanation goes here

C = eye(nodes);
if(connections >= 1)
	C = generate_connection_matrix( nodes, 1 );
	t1 = nodes;
	while(t1 < connections*nodes)
		t1 = t1+1;
		c1 = round(rand(1,1)*(nodes-1))+1;
		c2 = round(rand(1,1)*(nodes-1))+1;
		if(C(c1,c2) == 1)
			t1 = t1-1;
		else
			C(c1,c2) = 1;
		end
	end
end

end

