% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

function [ dsp_avg, ...
           dfrogs_avg, ...
           domp_avg ] ...
           = fig2_simulation( M, num_vec, num_mat, num_usr, C, binary, SMNR, ~, ~, ~ )

clearvars -except M num_vec num_mat num_usr C binary SMNR N Kc Kp;

addpath algorithms;

%% Set some program specific details
disp(['working dir: ' pwd]);
RandStream.setDefaultStream(RandStream('mt19937ar','seed',1));

%% Set variables
dsp_avg = zeros(4,1);

dfrogs_avg = zeros(4,1);

domp_avg = zeros(4,1);

N = 500;
Kc = 10;
Kp = 10;

%% Create data

% Connection matrices
% worst-case connection matrix
C_full = ones(num_usr,num_usr);

disp('Generating sensing matrices...')
% Sensing matrices
A_cell = cell(num_mat, num_usr);
for t1 = 1:num_mat
  for t2 = 1:num_usr
    A_cell{t1,t2} = create_sensing_matrix(N,M);
  end
end

disp('Generating data vectors...')
% Data vectors
x_cell = cell(num_vec, num_usr);
I_cell = cell(num_vec, num_usr);
for t1 = 1:num_vec
  Ic = randperm(N);
  Ic = Ic(1:Kc);
  
  for t2 = 1:num_usr
    Ip = randperm(N);
    Ip = Ip(1:Kp);
    [x_cell{t1,t2}, x_power] = create_data(N, Ic, Ip, binary);
    I_cell{t1,t2} = union(Ic, Ip);
  end
end

disp('Generating measurement vectors...')
% Measurement vectors
y_cell = cell(num_mat, num_vec, num_usr);
for t1 = 1:num_mat
  for t2 = 1:num_vec
    for t3 = 1:num_usr
      A = A_cell{t1,t3};
      x = x_cell{t2,t3};
      y = A*x;
      
      if(SMNR < Inf)
        % Add stuff for noise component
        sigma = sqrt(x_power/(M*10^(SMNR/10))); % Noise in dB
        n = sigma*randn(M,1);
        y = y + n;
      end
    
      y_cell{t1,t2,t3} = y;
    end
  end
end


disp('Running simulation')
%% Run simulation
ASCE_dsp = 0;
SRNR_dsp = zeros(2,1);
RES_dsp = 0;
toc_dsp = 0;

ASCE_dfrogs= 0;
SRNR_dfrogs= zeros(2,1);
RES_dfrogs = 0;
toc_dfrogs = 0;

ASCE_domp= 0;
SRNR_domp= zeros(2,1);
RES_domp = 0;
toc_domp = 0;

for t1 = 1:num_mat
  for t2 = 1:num_vec
    %disp('Working...');
    tic;
    [I_cell_dsp, x_cell_dsp, r_cell_dsp] ... 
      = dsp(C, A_cell(t1,:), y_cell(t1,t2,:), Kp, Kc, num_usr);
    toc_tdsp = toc;

    tic;
    [I_cell_dfrogs, x_cell_dfrogs, r_cell_dfrogs] ... 
      = dfrogs(C, A_cell(t1,:), y_cell(t1,t2,:), Kp, Kc, num_usr);
    toc_tdfrogs = toc;
    
    tic;
    [I_cell_domp, x_cell_domp, r_cell_domp] ... 
      = domp(C, A_cell(t1,:), y_cell(t1,t2,:), Kp, Kc, num_usr);
    toc_tdomp = toc;
    
    for t3 = 1:num_usr
      
      ASCE_dsp = ASCE_dsp + 1 ...
        - length(intersect(I_cell_dsp{t3}, I_cell{t2,t3}))...
        / length(I_cell{t2,t3});
      SRNR_dsp(1) = SRNR_dsp(1) + norm(x_cell{t2,t3},2)^2;
      SRNR_dsp(2) = SRNR_dsp(2) + norm(x_cell{t2,t3}-x_cell_dsp{t3},2)^2;
      RES_dsp = RES_dsp + norm(r_cell_dsp{t3})^2;
      toc_dsp = toc_dsp + toc_tdsp;
      
      ASCE_dfrogs = ASCE_dfrogs + 1 ...
        - length(intersect(I_cell_dfrogs{t3}, I_cell{t2,t3}))...
        / length(I_cell{t2,t3});
      SRNR_dfrogs(1) = SRNR_dfrogs(1) + norm(x_cell{t2,t3},2)^2;
      SRNR_dfrogs(2) = SRNR_dfrogs(2) + norm(x_cell{t2,t3}-x_cell_dfrogs{t3},2)^2;
      RES_dfrogs = RES_dfrogs + norm(r_cell_dfrogs{t3})^2;
      toc_dfrogs = toc_dfrogs + toc_tdfrogs;
      
      ASCE_domp = ASCE_domp + 1 ...
        - length(intersect(I_cell_domp{t3}, I_cell{t2,t3}))...
        / length(I_cell{t2,t3});
      SRNR_domp(1) = SRNR_domp(1) + norm(x_cell{t2,t3},2)^2;
      SRNR_domp(2) = SRNR_domp(2) + norm(x_cell{t2,t3}-x_cell_domp{t3},2)^2;
      RES_domp = RES_domp + norm(r_cell_domp{t3})^2;
      toc_domp = toc_domp + toc_tdomp;
    end
  end
end

dsp_avg(1) = ASCE_dsp/(num_mat * num_vec * num_usr);
dsp_avg(2) = 10*log10(SRNR_dsp(1)/SRNR_dsp(2));
dsp_avg(3) = RES_dsp/(num_mat * num_vec * num_usr);
dsp_avg(4) = toc_dsp/(num_mat * num_vec * num_usr);

dfrogs_avg(1) = ASCE_dfrogs/(num_mat * num_vec * num_usr);
dfrogs_avg(2) = 10*log10(SRNR_dfrogs(1)/SRNR_dfrogs(2));
dfrogs_avg(3) = RES_dfrogs/(num_mat * num_vec * num_usr);
dfrogs_avg(4) = toc_dfrogs/(num_mat * num_vec * num_usr);

domp_avg(1) = ASCE_domp/(num_mat * num_vec * num_usr);
domp_avg(2) = 10*log10(SRNR_domp(1)/SRNR_domp(2));
domp_avg(3) = RES_domp/(num_mat * num_vec * num_usr);
domp_avg(4) = toc_domp/(num_mat * num_vec * num_usr);

end
