% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

function [] = fig3456_simulation_launcher(M, binary, SMNR)
num_vec = 100;
num_mat = 100;
num_usr = 10;
N = 500;
Kc = 10;
Kp = 10;

sp_avg = zeros(length(M), 4);
jsp_avg = zeros(length(M), 4);
dsp_avg = zeros(length(M), 4);

frogs_avg = zeros(length(M), 4);
jfrogs_avg = zeros(length(M), 4);
dfrogs_avg = zeros(length(M), 4);

omp_avg = zeros(length(M), 4);
jomp_avg = zeros(length(M), 4);
domp_avg = zeros(length(M), 4);

%% Generate connection matrix of degree 2
C_cell = cell(num_usr, 1);
C = eye(num_usr, num_usr); % corresponds to a regular CS set-up
C_cell{1} = C;
for t1 = 2:num_usr
   C_cell{t1} = C_cell{t1-1}|circshift(C, [-(t1-1) 0]);
end

C = C_cell{3};

tstart = tic;
for m = 1:length(M)
  disp(['progress: ' num2str(round((m-1)/length(M)*100)) '%']);
  use_m = M(m);
  [ sp_avg(m,:),     jsp_avg(m,:),     dsp_avg(m,:), ...
    frogs_avg(m,:),  jfrogs_avg(m,:),  dfrogs_avg(m,:), ...
    omp_avg(m,:),    jomp_avg(m,:),    domp_avg(m,:) ] ...
      = fig3456_simulation(use_m, num_vec, num_mat, num_usr, C, binary, SMNR, N, Kc, Kp);
end
toc(tstart)

filename = ['./data/bin' int2str(binary) int2str(SMNR) ...
            '/simulation_' int2str(min(M)) 'to' ...
            int2str(max(M)) 'SMNR' int2str(SMNR) 'binary' ...
            int2str(binary) '.mat'];
        
save(filename, 'sp_avg',     'jsp_avg',     'dsp_avg', ...
               'frogs_avg',  'jfrogs_avg',  'dfrogs_avg', ...
               'omp_avg',    'jomp_avg',    'domp_avg','C');



end