% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

function [ x, x_power ] = create_data( N, Ic, Ip, binar)
Kp = length(Ip);
Kc = length(Ic);
x = zeros(N,1);

% Create individual data
if(binar == 0)
  zc = randn(Kc, 1);
  zp = randn(Kp, 1);
else
  zc = ones(Kc, 1);
  zp = ones(Kp, 1);
end

x(Ic) = zc;
x(Ip) = x(Ip) + zp;

x_power = length(union(Ic, Ip));

end