% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 


%%
%% Observe that in order to save simulations we re-use the data achieved
%% by fig3456_run_this.m. Thus, in order to provide these plots, the
%% fig3456_run_this.m must be run first.
%%

clear all;

num_usr = 10;
M = 40:5:150;
N = 500;


dipp_SRNR_full = [];
ipp_SRNR_full = [];

load('simulation_40to65SMNR20binary0.mat');
dipp_SRNR_full = [dipp_SRNR_full ; dipp_SRNR];
ipp_SRNR_full = [ipp_SRNR_full ; ipp_SRNR];

load('simulation_70to95SMNR20binary0.mat');
dipp_SRNR_full = [dipp_SRNR_full ; dipp_SRNR];
ipp_SRNR_full = [ipp_SRNR_full ; ipp_SRNR];

load('simulation_100to120SMNR20binary0.mat');
dipp_SRNR_full = [dipp_SRNR_full ; dipp_SRNR];
ipp_SRNR_full = [ipp_SRNR_full ; ipp_SRNR];

load('simulation_125to150SMNR20binary0.mat');
dipp_SRNR_full = [dipp_SRNR_full ; dipp_SRNR];
ipp_SRNR_full = [ipp_SRNR_full ; ipp_SRNR];

figure(2), clf
plot(M/N, 10*log(ipp_SRNR_full(:,1))/log(10), 'r-x','LineWidth',2), hold on,
plot(M/N, 10*log(dipp_SRNR_full(:,3))/log(10), 'g--o','LineWidth',1.4), hold on,
plot(M/N, 10*log(dipp_SRNR_full(:,4))/log(10), 'b--s','LineWidth',1.4), hold on,
plot(M/N, 10*log(dipp_SRNR_full(:,5))/log(10), 'k--d','LineWidth',1.4), hold on,
plot(M/N, 10*log(dipp_SRNR_full(:,10))/log(10), 'm--*','LineWidth',1.4), hold on,


xlabel('\alpha [M/N]'),
ylabel('SRER [dB]'), grid on,
legend('SP', 'DPP C_2', 'DPP C_3', 'DPP C_4', 'DPP C_9','Location','NorthWest'),
axis([0.1 0.21 0 23])
set(gca, 'LooseInset', [0,0,0,0])
set(figure(2), 'Position', [100, 100, 560, 420])
fontsize = 14;
set(gca,'FontSize',fontsize)
h_xlabel = get(gca,'XLabel');
h_ylabel = get(gca,'YLabel');
set(h_xlabel,'FontSize',fontsize);
set(h_ylabel,'FontSize',fontsize);
saveas(gcf, 'bin0SMNR20_SRNR.eps', 'psc2');