% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 


%%
%% Observe that in order to save simulations we re-use the data achieved
%% by %fig3456_run_this.m. Thus, in order to provide these plots, the
%% fig3456_run_this.m must be run first.
%%

clear all;

num_usr = 10;
M = 40:5:150;
N = 500;


dipp_inner_loop_full = [];
ipp_inner_loop_full = [];
dipp_inner_loop_squared_full = [];
ipp_inner_loop_squared_full = [];
ipp_inner_loop_squared = 0;

load('simulation_40to65SMNR20binary0.mat');
dipp_inner_loop_full = [dipp_inner_loop_full ; dipp_inner_loop];
ipp_inner_loop_full = [ipp_inner_loop_full ; ipp_inner_loop];
dipp_inner_loop_squared_full = [dipp_inner_loop_squared_full ; dipp_inner_loop_squared];
ipp_inner_loop_squared_full = [ipp_inner_loop_squared_full ; ipp_inner_loop_squared];

load('simulation_70to95SMNR20binary0.mat');
dipp_inner_loop_full = [dipp_inner_loop_full ; dipp_inner_loop];
ipp_inner_loop_full = [ipp_inner_loop_full ; ipp_inner_loop];
dipp_inner_loop_squared_full = [dipp_inner_loop_squared_full ; dipp_inner_loop_squared];
ipp_inner_loop_squared_full = [ipp_inner_loop_squared_full ; ipp_inner_loop_squared];

load('simulation_100to120SMNR20binary0.mat');
dipp_inner_loop_full = [dipp_inner_loop_full ; dipp_inner_loop];
ipp_inner_loop_full = [ipp_inner_loop_full ; ipp_inner_loop];
dipp_inner_loop_squared_full = [dipp_inner_loop_squared_full ; dipp_inner_loop_squared];
ipp_inner_loop_squared_full = [ipp_inner_loop_squared_full ; ipp_inner_loop_squared];

load('simulation_125to150SMNR20binary0.mat');
dipp_inner_loop_full = [dipp_inner_loop_full ; dipp_inner_loop];
ipp_inner_loop_full = [ipp_inner_loop_full ; ipp_inner_loop];
dipp_inner_loop_squared_full = [dipp_inner_loop_squared_full ; dipp_inner_loop_squared];
ipp_inner_loop_squared_full = [ipp_inner_loop_squared_full ; ipp_inner_loop_squared];

dipp_sigma = sqrt(dipp_inner_loop_squared_full - dipp_inner_loop_full.^2);
ipp_sigma = sqrt(ipp_inner_loop_squared_full - ipp_inner_loop_full.^2);

figure(3), clf
errorbar(M(2:end)/N, ipp_inner_loop_full(2:end,1), ipp_sigma(2:end,1), 'r-x','LineWidth',2), hold on,
%plot(M/N, ipp_inner_loop_full(:,1), 'k:.','LineWidth',2), hold on,
%errorbar(M/N, dipp_inner_loop_full(:,1), dipp_sigma(:,1),'k:.','LineWidth',1.4), hold on,
%plot(M/N, dipp_inner_loop_full(:,3), 'g--x','LineWidth',1.4), hold on,
%errorbar(M/N, dipp_inner_loop_full(:,3), dipp_sigma(:,3),'g--x','LineWidth',1.4), hold on,
%plot(M/N, dipp_inner_loop_full(:,4), 'r-o','LineWidth',1.4), hold on,
errorbar(M(2:end)/N, dipp_inner_loop_full(2:end,5), dipp_sigma(2:end,5),'k-.o','LineWidth',1), hold on,
%plot(M/N, dipp_inner_loop_full(:,5), 'b-.d','LineWidth',1.4), hold on,
%errorbar(M/N, dipp_inner_loop_full(:,10), dipp_sigma(:,10),'b-.d','LineWidth',1.4), hold on,
%plot(M/N, dipp_inner_loop_full(:,10), 'b-.d','LineWidth',1.4), hold on,

%plot(M/N, 10*log(dipp_inner_loop_full(:,1))/log(10), 'b','LineWidth',1), hold on,
legend('PP', 'DPP C_4');
xlabel('\alpha [M/N]'),
ylabel('E[l] (inner\_loop)'), grid on,
axis([0.08 0.31 2 8])
set(gca, 'LooseInset', [0,0,0,0])
set(figure(3), 'Position', [100, 100, 280, 420])
%fontsize = 14;
%set(gca,'FontSize',fontsize)
h_xlabel = get(gca,'XLabel');
h_ylabel = get(gca,'YLabel');
%set(h_xlabel,'FontSize',fontsize);
%set(h_ylabel,'FontSize',fontsize);
saveas(gcf, 'bin0SMNR20_inner_loop_two.eps', 'psc2');