% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 


%%
%% Observe that in order to save simulations we re-use the data achieved
%% by fig3456_run_this.m. Thus, in order to provide these plots, the
%% fig3456_run_this.m must be run first.
%%

clear all;

num_usr = 10;
M = 40:5:150;
N = 500;


dipp_ASCE_full = [];
ipp_ASCE_full = [];

load('simulation_40to65SMNRInfbinary0.mat');
dipp_ASCE_full = [dipp_ASCE_full ; dipp_ASCE];
ipp_ASCE_full = [ipp_ASCE_full ; ipp_ASCE];

load('simulation_70to95SMNRInfbinary0.mat');
dipp_ASCE_full = [dipp_ASCE_full ; dipp_ASCE];
ipp_ASCE_full = [ipp_ASCE_full ; ipp_ASCE];

load('simulation_100to120SMNRInfbinary0.mat');
dipp_ASCE_full = [dipp_ASCE_full ; dipp_ASCE];
ipp_ASCE_full = [ipp_ASCE_full ; ipp_ASCE];

load('simulation_125to150SMNRInfbinary0.mat');
dipp_ASCE_full = [dipp_ASCE_full ; dipp_ASCE];
ipp_ASCE_full = [ipp_ASCE_full ; ipp_ASCE];

figure(1), clf
plot(M/N, ipp_ASCE_full(:,1), 'r-x','LineWidth',2), hold on,
plot(M/N, dipp_ASCE_full(:,3), 'g--o','LineWidth',1.4), hold on,
plot(M/N, dipp_ASCE_full(:,4), 'b--s','LineWidth',1.4), hold on,
plot(M/N, dipp_ASCE_full(:,5), 'k--d','LineWidth',1.4), hold on,
plot(M/N, dipp_ASCE_full(:,10), 'm--*','LineWidth',1.4), hold on,

%plot(M/N, 10*log(dipp_ASCE_full(:,1))/log(10), 'b','LineWidth',1), hold on,
xlabel('\alpha [M/N]'),
ylabel('ASCE'), grid on,
legend('SP', 'DPP C_2', 'DPP C_3', 'DPP C_4', 'DPP C_9'),
axis([0.1 0.2 0 0.8])
set(gca, 'LooseInset', [0,0,0,0])
set(figure(1), 'Position', [100, 100, 560, 420])
fontsize = 14;
set(gca,'FontSize',fontsize)
h_xlabel = get(gca,'XLabel');
h_ylabel = get(gca,'YLabel');
set(h_xlabel,'FontSize',fontsize);
set(h_ylabel,'FontSize',fontsize);
saveas(gcf, 'bin0SMNRInf_ASCE.eps', 'psc2');