classdef measurements
    %UNTITLED2 Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
		inner_loop;
		inner_loop_count;
		inner_loop_squared;
		outer_loop;
		outer_loop_count;
		outer_loop_squared;
        ASCE;
        SRNR;
        SRNR_avg;
		P_hit;
		P_tot;
		P_avg;
        RES;
        TOC;
        avg;
    end
    
    methods
        function obj = measurements
			obj.inner_loop = 0;
			obj.inner_loop_squared = 0;
			obj.inner_loop_count = 0;
			obj.outer_loop = 0;
			obj.outer_loop_squared = 0;
			obj.outer_loop_count = 0;
            obj.ASCE = 0;
            obj.SRNR = zeros(2,1);
            obj.SRNR_avg = 0;
            obj.RES = 0;
            obj.TOC = 0;
            obj.avg = 0; %% to keep track of if we have averaged
			obj.P_hit = zeros(10,200); % 10 magic number for network
			obj.P_tot = zeros(10,200); % 200 magic number iteration (see dipp.m)
			obj.P_avg = zeros(10,200);
		end %measurements

		function obj = update_P(obj, k, n, Jh, TminI, x_true)
			%disp('something');
			%norm(x_true(Jh),2)
			%norm(x_true(TminI),2)
			if(norm(x_true(Jh),2) >= norm(x_true(TminI),2))
				obj.P_hit(n, k) = obj.P_hit(n,k) + 1;
			end
			obj.P_tot(n,k) = obj.P_tot(n,k) + 1;
		end % update_P

        function obj = update_ASCE(obj, I_data, I_orig)
            obj.ASCE = obj.ASCE + 1 -...
                length(intersect(I_data, I_orig))/length(I_orig);
        end % update_ASCE
      
        function obj = update_RES(obj, r)
            obj.RES = obj.RES + norm(r)^2;
        end % update_RES
        
        function obj = update_SRNR(obj, x, x_hat)
            obj.SRNR(1) = obj.SRNR(1) + norm(x,2)^2;
            obj.SRNR(2) = obj.SRNR(2) + norm(x-x_hat,2)^2;
        end %update_SRNR
        
        function obj = update_toc(obj, tocs)
            obj.TOC = obj.TOC + tocs;
		end
        
		function obj = update_inner(obj, count)
			obj.inner_loop_count = obj.inner_loop_count + 1;
			obj.inner_loop = obj.inner_loop + count;
			obj.inner_loop_squared = obj.inner_loop_squared + count^2;
		end
		
		function obj = update_outer(obj, count)
			obj.outer_loop_count = obj.outer_loop_count + 1;
			obj.outer_loop = obj.outer_loop + count;
			obj.outer_loop_squared = obj.outer_loop_squared + count^2;
		end
		
        function obj = average(obj, num_mat, num_vec, num_usr)
            if(obj.avg == 0)
                obj.ASCE = obj.ASCE/(num_mat * num_vec * num_usr);
                obj.SRNR_avg = obj.SRNR(1)/obj.SRNR(2);
                obj.RES = obj.RES/(num_mat * num_vec * num_usr);
                obj.TOC = obj.TOC/(num_mat * num_vec * num_usr);
				obj.inner_loop = obj.inner_loop/obj.inner_loop_count;
				obj.inner_loop_squared = obj.inner_loop_squared/obj.inner_loop_count;
				obj.outer_loop = obj.outer_loop/obj.outer_loop_count;
				obj.outer_loop_squared = obj.outer_loop_squared/obj.outer_loop_count;
				obj.P_avg = obj.P_hit./obj.P_tot;
				obj.avg = 1;
            end
        end
        
    end
    
end

