% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 


%%
%% Observe that in order to save simulations we re-use the data achieved
%% by %fig3456_run_this.m. Thus, in order to provide these plots, the
%% fig3456_run_this.m must be run first.
%

clear all;

num_usr = 10;
M = 40:5:150;
N = 500;


dipp_outer_loop_full = [];
ipp_outer_loop_full = [];

load('simulation_40to65SMNR20binary0.mat');
dipp_outer_loop_full = [dipp_outer_loop_full ; dipp_outer_loop];
%ipp_outer_loop_full = [ipp_outer_loop_full ; ipp_outer_loop];

load('simulation_70to95SMNR20binary0.mat');
dipp_outer_loop_full = [dipp_outer_loop_full ; dipp_outer_loop];
%ipp_outer_loop_full = [ipp_outer_loop_full ; ipp_outer_loop];

load('simulation_100to120SMNR20binary0.mat');
dipp_outer_loop_full = [dipp_outer_loop_full ; dipp_outer_loop];
%ipp_outer_loop_full = [ipp_outer_loop_full ; ipp_outer_loop];

load('simulation_125to150SMNR20binary0.mat');
dipp_outer_loop_full = [dipp_outer_loop_full ; dipp_outer_loop];
%ipp_outer_loop_full = [ipp_outer_loop_full ; ipp_outer_loop];

figure(4), clf
plot(M/N, dipp_outer_loop_full(:,3), 'r--o','LineWidth',1.4), hold on,
plot(M/N, dipp_outer_loop_full(:,4), 'b--s','LineWidth',1.4), hold on,
plot(M/N, dipp_outer_loop_full(:,5), 'm--d','LineWidth',1.4), hold on,
plot(M/N, dipp_outer_loop_full(:,10), 'g--*','LineWidth',1.4), hold on,
legend('DPP C_2', 'DPP C_3', 'DPP C_5', 'DPP C_9','Location','NorthEast'),
xlabel('\alpha [M/N]'),
ylabel('iterations'), grid on,
axis([0.08 0.30 0 40])
set(gca, 'LooseInset', [0,0,0,0])
set(figure(4), 'Position', [100, 100, 560, 420])
fontsize = 14;
set(gca,'FontSize',fontsize)
h_xlabel = get(gca,'XLabel');
h_ylabel = get(gca,'YLabel');
set(h_xlabel,'FontSize',fontsize);
set(h_ylabel,'FontSize',fontsize);
saveas(gcf, 'bin0SMNR20_outer_loop.eps', 'psc2');