% Intellectual Property Right (IPR) notice: Downloading of any code is
% permitted for personal use only. Permission to resale / redistribution
% / reuse for commercial purposes must be obtained from the author(s).
% IPR are retained by authors. 

function [ dipp_meas, ipp_meas ] ...
           = fig2_simulation( M, num_vec, num_mat, num_usr, C, binary, SMNR, N, Kc, Kp, nusr )

clearvars -except M num_vec num_mat num_usr C binary SMNR N Kc Kp nusr;

addpath algorithms;

%% Set some program specific details
disp(['working dir: ' pwd]);
RandStream.setDefaultStream(RandStream('mt19937ar','seed',1));

%% Set variables

% N = 500;
% Kc = 10;
% Kp = 10;

%% Create data

% Connection matrices
% worst-case connection matrix
C_full = ones(num_usr,num_usr);

disp('Generating sensing matrices...')
% Sensing matrices
A_cell = cell(num_mat, num_usr);
for t1 = 1:num_mat
  for t2 = 1:num_usr
    A_cell{t1,t2} = create_sensing_matrix(N,M);
  end
end

disp('Generating data vectors...')
% Data vectors
x_cell = cell(num_vec, num_usr);
I_cell = cell(num_vec, num_usr);
for t1 = 1:num_vec
  Ic = randperm(N);
  Ic = Ic(1:Kc);
  
  for t2 = 1:num_usr
    Ip = randperm(N);
    Ip = Ip(1:Kp);
    [x_cell{t1,t2}, x_power] = create_data(N, Ic, Ip, binary);
    I_cell{t1,t2} = union(Ic, Ip);
  end
end

disp('Generating measurement vectors...')
% Measurement vectors
y_cell = cell(num_mat, num_vec, num_usr);
for t1 = 1:num_mat
  for t2 = 1:num_vec
    for t3 = 1:num_usr
      A = A_cell{t1,t3};
      x = x_cell{t2,t3};
      y = A*x;
      
      if(SMNR < Inf)
        % Add stuff for noise component
        sigma = sqrt(x_power/(M*10^(SMNR/10))); % Noise in dB
        n = sigma*randn(M,1);
        y = y + n;
      end
    
      y_cell{t1,t2,t3} = y;
    end
  end
end


disp('Running simulation')
%% Run simulation
dipp_meas = measurements;
ipp_meas = measurements;
I_cell_ipp = cell(num_usr,1);
x_cell_ipp = cell(num_usr,1);
r_cell_ipp = cell(num_usr,1);

for t1 = 1:num_mat
  for t2 = 1:num_vec
    %disp('Working...');
	tic;
	[I_cell_dipp, x_cell_dipp, r_cell_dipp, dipp_meas] ...
		= dipp(C, A_cell(t1,:), y_cell(t1,t2,:), Kp + Kc, num_usr, dipp_meas, nusr, x_cell(t2,:));
	toc_dipp = toc;
	
	for t3 = 1:num_usr
		tic;
		[I_cell_ipp{t3}, x_cell_ipp{t3}, r_cell_ipp{t3}, l] ...
			= ipp(A_cell{t1,t3}, y_cell{t1,t2,t3}, Kp + Kc, []);
		ipp_meas = ipp_meas.update_inner(l);
		toc_ipp = toc;
	end

    for t3 = 1:num_usr
      dipp_meas = dipp_meas.update_ASCE(I_cell_dipp{t3}, I_cell{t2,t3});
      dipp_meas = dipp_meas.update_SRNR(x_cell{t2,t3}, x_cell_dipp{t3});
      dipp_meas = dipp_meas.update_RES(r_cell_dipp{t3});
      dipp_meas = dipp_meas.update_toc(toc_dipp);
	  
	  ipp_meas = ipp_meas.update_ASCE(I_cell_ipp{t3}, I_cell{t2,t3});
      ipp_meas = ipp_meas.update_SRNR(x_cell{t2,t3}, x_cell_ipp{t3});
      ipp_meas = ipp_meas.update_RES(r_cell_ipp{t3});
      ipp_meas = ipp_meas.update_toc(toc_ipp);
    end
  end
end

dipp_meas = dipp_meas.average(num_mat, num_vec, num_usr);
ipp_meas = ipp_meas.average(num_mat, num_vec, num_usr);

end
