%%
% This file produces results for Fig. 2 in paper "SEK: Sparsity exploiting
% k -mer-based estimation of bacterial community composition"

close all; clc; clear;

%%
%%%% Necessary files %%%%

% Sequence data
READ_seq = fastaread('Measurement.fasta');
REF_seq = fastaread('Reference.fasta');



%%
% Varibale definition
k_SEK = 4;  % k-mer for k = 4, in the case of SEK
NoOfSpecies = 21; % Number of species in the reference database



%%
% SEK implementation (using OMP^{+,1} algorithm

[result_SEK elapsedtime_READ elapsedtime_REF elapsedtime_algo] = SEK_implementation(k_SEK,READ_seq,REF_seq,NoOfSpecies);



%%
% Comparison

% loading ground truth for comparison
load('GroundTruth.mat');

true_solution=sol_species';  % sol_species comes from Ground Truth (GroundTruth.mat)
true_solution=true_solution/sum(true_solution);


VD_SEK = 0.5 * norm((true_solution - result_SEK),1);

disp('Variational distance performance:'); VD_SEK

% Showing bar chart
BarY = [true_solution; result_SEK];
BarX = 1:21;
bar(BarX,BarY',1)
legend('Ground Truth', 'SEK:OMP^{+,1}');
axis([0 22 0 0.3]);
xlabel('species'); ylabel('proportion');
