function kmer_vector = kmer_statistics(seq, k)


    kmer_vector = zeros(4^k,1);
    kmer = nmercount(seq, k);
    
    
    if k == 3
        power = uint16([4^2 4 1]);
    elseif k == 4
        power = uint16([4^3 4^2 4 1]);
    elseif k == 5
        power = uint16([4^4 4^3 4^2 4 1]);
    elseif k == 6
        power = uint16([4^5 4^4 4^3 4^2 4 1]);
    elseif k == 7
        power = uint16([4^6 4^5 4^4 4^3 4^2 4 1]);
    elseif k == 8
        power = uint16([4^8 4^6 4^5 4^4 4^3 4^2 4 1]);
    else
        disp('Warning! The input k is less than 3 or bigger than 8!')
    end
    
       
    for i = 1:size(kmer(:,1))
        pos = sum(uint16(nt2int(kmer{i,1})-1).*power) + 1;
        kmer_vector(pos) = kmer{i,2};
       
    end
    
    kmer_vector=kmer_vector(1:4^k);  % Saikat adds this line (sometimes kmer_vector size is more than 4^k)
    
    kmer_vector = kmer_vector/sum(kmer_vector);
    
end