function generate_read_kmer_vector_SEK(READ_seq, k)

    % This script is used to read in all the read sequences and choose the first 450bp fragment. 
    % Then get the kmer vector for all of them. Finally to save these variance into a datafile.
    
    % k is used to set kmer.
    
    % reads = fastaread(infile);
    reads = READ_seq;

    n = size(reads,1);
    
    kmer_vector_reads = zeros(n, 4^k);
    
    disp('Generating k-mers for reads (or measurement data)');
    
    for i = 1:n
        
%         disp(reads(i,1).Header);
        
        L = 450; % the length of fragment is set as 450bp.
        
        seq = reads(i,1).Sequence;
        
        kmer_vector_reads(i,:) = kmer_statistics(seq(1:L),k)';
      
    end
    filename = 'kmer_vector_reads_SEK.mat';
    save(filename,'kmer_vector_reads');
end