function [xp_iter] = DHTP_func(y,A,M,N,K,num_nodes,network_mat)

max_iter = 30;

xp_iter = [];iter_count = 0;
I = zeros(num_nodes*K,1);
y_r = zeros(num_nodes*M,1);

y_residue_old_all = y;
I_Old_all = zeros(num_nodes*K,1);
status_flag = ones(1,num_nodes);

%% DHTP
x_1_mat = zeros(N,num_nodes);
x_3_mat = zeros(N,num_nodes);

while (sum(status_flag) > 0)
    iter_count = iter_count + 1;
    if iter_count == 1
        xp_iter = zeros(num_nodes*N,1);
    else
        xp_iter = [xp_iter xp_iter(:,iter_count-1)];
    end
    
    idx_set = [];
    for node_loop = 1:num_nodes
        
        if status_flag(node_loop) > 0
            idx_set = [idx_set node_loop];
            
            y_now = y((node_loop-1)*M +1:node_loop*M,1);
            A_now = A((node_loop-1)*M +1:node_loop*M,:);
            x_old_now = xp_iter((node_loop-1)*N+1:node_loop*N,iter_count);
            
            I_1 = support_set_eval(x_old_now + A_now'*(y_now-A_now*x_old_now),K);  % Step 1
            
            A_I_1 = A_now(:,I_1);
            x_dummy_1 = pinv(A_I_1)*y_now;
            x_1 = zeros(N,1);
            x_1(I_1) = x_dummy_1;
            x_1_mat(:,node_loop) = x_1; % Step 2
        end
    end
    x_3_mat(:,idx_set) = x_1_mat*network_mat(idx_set,:).'; % Step 3
    for node_loop = 1:num_nodes
        
        if status_flag(node_loop) > 0
            
            y_now = y((node_loop-1)*M +1:node_loop*M,1);
            A_now = A((node_loop-1)*M +1:node_loop*M,:);
            
            x_3 = x_3_mat(:,node_loop);
            
            I_4 = support_set_eval(x_3,K);  % Step 4
            x_4= zeros(N,1);
            x_4(I_4) = x_3(I_4); % Step 5
            
            y_residue_new=residue_for_Subspace_pursuit(y_now,A_now,I_4); 
            
            % Stopping criterion
            if iter_count == max_iter
                status_flag(node_loop) = 0;
                
                I_Old_all((node_loop-1)*K+1:node_loop*K,1)=I_4;
                y_residue_old_all((node_loop-1)*M+1:node_loop*M,1)=y_residue_new;
                
                I((node_loop-1)*K+1:node_loop*K,1) = I_4;
                y_r((node_loop-1)*M+1:node_loop*M,1) = y_residue_new;
                
                xp_iter((node_loop-1)*N+1:node_loop*N,iter_count) = x_4;
            else
                I_Old_all((node_loop-1)*K+1:node_loop*K,1)=I_4;
                y_residue_old_all((node_loop-1)*M+1:node_loop*M,1)=y_residue_new;
                
                xp_iter((node_loop-1)*N+1:node_loop*N,iter_count) = x_4;
            end
        end
    end
end

%%
%% Function to calculate residue
function y_residue=residue_for_Subspace_pursuit(y,A,I)

% y <- measurement
% A <- CS measurement matrix
% I <- Support set for large amplitude coeffs

% y_residue -> orthogonal projection residue


% Forming a matrix by picking columns indexed by I
A_I=A(:,I);
y_p=A_I * pinv(A_I) * y;
y_residue = y - y_p;
% -------------------------------------------------------


