display('------------------- Noise Robustness experiment--------------------');

load network_mat3;
load nmat;

max_iter = 30;
SRNR_dhtp_gaussian1 = zeros(6,max_iter);PSE_dhtp_gaussian1 = zeros(6,max_iter);
SRNR_dihat_gaussian1 = zeros(6,max_iter);PSE_dihat_gaussian1 = zeros(6,max_iter);
SRNR_dhtp_gaussian2 = zeros(6,max_iter);PSE_dhtp_gaussian2 = zeros(6,max_iter);
SRNR_dihat_gaussian2 = zeros(6,max_iter);PSE_dihat_gaussian2 = zeros(6,max_iter);
SRNR_htp_gaussian = zeros(6,max_iter);PSE_htp_gaussian = zeros(6,max_iter);

%% ------- DHTP- Gaussian case - Right stochastic matrix ----------------%%
display('------------------- DHTP- Gaussian case--------------------');
[SRNR_dhtp_gaussian1(1,:),PSE_dhtp_gaussian1(1,:)] = comp_distributed_CS_algo(10, 'Gaussian', 'dhtp', 100, 500, 20,20, nmat);
[SRNR_dhtp_gaussian1(2,:),PSE_dhtp_gaussian1(2,:)] = comp_distributed_CS_algo(20, 'Gaussian', 'dhtp', 100, 500, 20,20, nmat);
[SRNR_dhtp_gaussian1(3,:),PSE_dhtp_gaussian1(3,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'dhtp', 100, 500, 20,20, nmat);
[SRNR_dhtp_gaussian1(4,:),PSE_dhtp_gaussian1(4,:)] = comp_distributed_CS_algo(40, 'Gaussian', 'dhtp', 100, 500, 20,20, nmat);
[SRNR_dhtp_gaussian1(5,:),PSE_dhtp_gaussian1(5,:)] = comp_distributed_CS_algo(50, 'Gaussian', 'dhtp', 100, 500, 20,20, nmat);
[SRNR_dhtp_gaussian1(6,:),PSE_dhtp_gaussian1(6,:)] = comp_distributed_CS_algo(60, 'Gaussian', 'dhtp', 100, 500, 20,20, nmat);

%% ------- DiHaT- Gaussian case - Right stochastic matrix ----------------%%
display('------------------- DiHaT- Gaussian case--------------------');
[SRNR_dihat_gaussian1(1,:),PSE_dihat_gaussian1(1,:)] = comp_distributed_CS_algo(10, 'Gaussian', 'dihat', 100, 500, 20,20, nmat);
[SRNR_dihat_gaussian1(2,:),PSE_dihat_gaussian1(2,:)] = comp_distributed_CS_algo(20, 'Gaussian', 'dihat', 100, 500, 20,20, nmat);
[SRNR_dihat_gaussian1(3,:),PSE_dihat_gaussian1(3,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'dihat', 100, 500, 20,20, nmat);
[SRNR_dihat_gaussian1(4,:),PSE_dihat_gaussian1(4,:)] = comp_distributed_CS_algo(40, 'Gaussian', 'dihat', 100, 500, 20,20, nmat);
[SRNR_dihat_gaussian1(5,:),PSE_dihat_gaussian1(5,:)] = comp_distributed_CS_algo(50, 'Gaussian', 'dihat', 100, 500, 20,20, nmat);
[SRNR_dihat_gaussian1(6,:),PSE_dihat_gaussian1(6,:)] = comp_distributed_CS_algo(60, 'Gaussian', 'dihat', 100, 500, 20,20, nmat);

%% ------- DHTP- Gaussian case - Doubly stochastic matrix ----------------%%
display('------------------- DHTP- Gaussian case--------------------');
[SRNR_dhtp_gaussian2(1,:),PSE_dhtp_gaussian2(1,:)] = comp_distributed_CS_algo(10, 'Gaussian', 'dhtp', 100, 500, 20,20, network_mat3);
[SRNR_dhtp_gaussian2(2,:),PSE_dhtp_gaussian2(2,:)] = comp_distributed_CS_algo(20, 'Gaussian', 'dhtp', 100, 500, 20,20, network_mat3);
[SRNR_dhtp_gaussian2(3,:),PSE_dhtp_gaussian2(3,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'dhtp', 100, 500, 20,20, network_mat3);
[SRNR_dhtp_gaussian2(4,:),PSE_dhtp_gaussian2(4,:)] = comp_distributed_CS_algo(40, 'Gaussian', 'dhtp', 100, 500, 20,20, network_mat3);
[SRNR_dhtp_gaussian2(5,:),PSE_dhtp_gaussian2(5,:)] = comp_distributed_CS_algo(50, 'Gaussian', 'dhtp', 100, 500, 20,20, network_mat3);
[SRNR_dhtp_gaussian2(6,:),PSE_dhtp_gaussian2(6,:)] = comp_distributed_CS_algo(60, 'Gaussian', 'dhtp', 100, 500, 20,20, network_mat3);

%% ------- DiHaT- Gaussian case - Doubly stochastic matrix ----------------%%
display('------------------- DiHaT- Gaussian case--------------------');
[SRNR_dihat_gaussian2(1,:),PSE_dihat_gaussian2(1,:)] = comp_distributed_CS_algo(10, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_gaussian2(2,:),PSE_dihat_gaussian2(2,:)] = comp_distributed_CS_algo(20, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_gaussian2(3,:),PSE_dihat_gaussian2(3,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_gaussian2(4,:),PSE_dihat_gaussian2(4,:)] = comp_distributed_CS_algo(40, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_gaussian2(5,:),PSE_dihat_gaussian2(5,:)] = comp_distributed_CS_algo(50, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_gaussian2(6,:),PSE_dihat_gaussian2(6,:)] = comp_distributed_CS_algo(60, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);

%% ------- HTP- Gaussian case ----------------%%
display('------------------- DHTP- Gaussian case--------------------');
[SRNR_htp_gaussian(1,:),PSE_htp_gaussian(1,:)] = comp_distributed_CS_algo(10, 'Gaussian', 'dhtp', 100, 500, 20,20, eye(20));
[SRNR_htp_gaussian(2,:),PSE_htp_gaussian(2,:)] = comp_distributed_CS_algo(20, 'Gaussian', 'dhtp', 100, 500, 20,20, eye(20));
[SRNR_htp_gaussian(3,:),PSE_htp_gaussian(3,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'dhtp', 100, 500, 20,20, eye(20));
[SRNR_htp_gaussian(4,:),PSE_htp_gaussian(4,:)] = comp_distributed_CS_algo(40, 'Gaussian', 'dhtp', 100, 500, 20,20, eye(20));
[SRNR_htp_gaussian(5,:),PSE_htp_gaussian(5,:)] = comp_distributed_CS_algo(50, 'Gaussian', 'dhtp', 100, 500, 20,20, eye(20));
[SRNR_htp_gaussian(6,:),PSE_htp_gaussian(6,:)] = comp_distributed_CS_algo(60, 'Gaussian', 'dhtp', 100, 500, 20,20, eye(20));



%% -----------------Plotting results --------------------%%
figure;
subplot(1,2,1);
plot([10 20 30 40 50 60],SRNR_dhtp_gaussian1(:,end)','kx-');hold on;grid on;
plot([10 20 30 40 50 60],SRNR_dihat_gaussian1(:,end)','ko-');
plot([10 20 30 40 50 60],SRNR_htp_gaussian(:,end)','kd--');
legend('DHTP','DiHaT','HTP');
xlabel('SNR (in dB)');
ylabel('mSENR (in dB)');
title('For right stochastic matrix');

subplot(1,2,2);
plot([10 20 30 40 50 60],SRNR_dhtp_gaussian2(:,end)','kx-');hold on;grid on;
plot([10 20 30 40 50 60],SRNR_dihat_gaussian2(:,end)','ko-');
plot([10 20 30 40 50 60],SRNR_htp_gaussian(:,end)','kd--');
legend('DHTP','DiHaT','HTP');
xlabel('SNR (in dB)');
ylabel('mSENR (in dB)');
title('For doubly stochastic matrix');