display('------------------- Convergence rate experiment--------------------');

load network_mat3;

max_iter = 30;
SRNR_dhtp_gaussian = zeros(2,max_iter);PSE_dhtp_gaussian = zeros(2,max_iter);
SRNR_dihat_gaussian = zeros(2,max_iter);PSE_dihat_gaussian = zeros(2,max_iter);

%% ------- DHTP- Gaussian case ----------------%%
display('------------------- DHTP- Gaussian case--------------------');
[SRNR_dhtp_gaussian(1,:),PSE_dhtp_gaussian(1,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'dhtp', 100, 500, 20,20, network_mat3);
[SRNR_dhtp_gaussian(2,:),PSE_dhtp_gaussian(2,:)] = comp_distributed_CS_algo(200, 'Gaussian', 'dhtp', 100, 500, 20,20, network_mat3);

%% ------- DiHaT- Gaussian case ----------------%%
display('------------------- DiHaT- Gaussian case--------------------');
[SRNR_dihat_gaussian(1,:),PSE_dihat_gaussian(1,:)] = comp_distributed_CS_algo(30, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);
[SRNR_dihat_gaussian(2,:),PSE_dihat_gaussian(2,:)] = comp_distributed_CS_algo(200, 'Gaussian', 'dihat', 100, 500, 20,20, network_mat3);

%% -----------------Plotting results --------------------%%
figure;
subplot(1,2,1);
plot([1:30],SRNR_dhtp_gaussian(2,:),'x-');hold on;grid on;
plot([1:30],SRNR_dihat_gaussian(2,:),'o-');
legend('DHTP','DiHaT');
xlabel('Number of iterations');
ylabel('mSENR (in dB)');
title('No noise');

subplot(1,2,2);
plot([1:30],SRNR_dhtp_gaussian(1,:),'x-');hold on;grid on;
plot([1:30],SRNR_dihat_gaussian(1,:),'o-');
legend('DHTP, SNR = 30dB','DiHaT, SNR = 30dB');
xlabel('Number of iterations');
ylabel('mSENR (in dB)');
title('With noise');